<?php
// If it's going to need the database, then it's 
// probably smart to require it before we start.
require_once('database.php');

class accountExpense {
	
	protected static $table_name="acc_expense";
	protected static $db_fields = array('expense_id','staff_id',
	 'sess_id','term_id', 'created_on','item_name', 'cat_name', 'expense_amount', 'edited_on', 'received_by');
	
	
	public $id;
	public $item_name;
	public $cat_name;
	public $expense_id;
	public $staff_id;
	public $sess_id;
	public $term_id;
	public $expense_amount;
	public $created_on;
	public $edited_on;
	public $received_by;
	 
	
 

	// Common Database Methods
	public static function find_all($sess_id, $term_id) {
		return self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE `sess_id`= '{$sess_id}' AND `term_id`='{$term_id}'");
  }
  public static function find_all_by_date_range($from, $to, $item_name) {

		return self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE  created_on BETWEEN '{$from}' AND '{$to}'");
  }

   public static function find_an_item_by_date_range($from, $to, $item_name) {

		return self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE  created_on BETWEEN '{$from}' AND '{$to}' AND `item_name`= '{$item_name}'");
  }
   public static function find_total_expense($sess_id, $term_id) {
   	global $database;
			$sql=$database->fetch_array($database->query("SELECT sum(expense_amount) AS amount FROM ".self::$table_name ." WHERE   `sess_id`= '{$sess_id}' AND `term_id`='{$term_id}' "));
			return $sql['amount'];
	 }

	  public static function find_total_expense_by_item_name($from, $to, $item_name) {
	  	global $database;
			$sql=$database->fetch_array($database->query("SELECT sum(expense_amount) AS amount FROM ".self::$table_name." WHERE  created_on BETWEEN '{$from}' AND '{$to}' AND `item_name`= '{$item_name}'"));
			return $sql['amount'];
	 }


public static function find_total_expense_by_range($date, $item_name) {
	  	global $database;
			$sql=$database->fetch_array($database->query("SELECT sum(expense_amount) AS amount FROM ".self::$table_name." WHERE  created_on  = '{$date}'"));
			return $sql['amount'];
	 }

	   public static function find_total_number_of_items($sess_id, $term_id) {
	   	global $database;
			$sql=$database->num_rows($database->query("SELECT DISTINCT `item_name` FROM ".self::$table_name ." WHERE `term_id`='{$term_id}' AND `sess_id`= '{$sess_id}' "));
			return $sql;
	 }
	 
  
 public static  function format_currency($val,$symbol='₦',$r=2)
{


    $n = $val; 
    $c = is_float($n) ? 1 : number_format($n,$r);
    $d = '.';
    $t = ',';
    $sign = ($n < 0) ? '-' : '';
    $i = $n=number_format(abs($n),$r); 
    $j = (($j = strlen($i)) > 3) ? $j % 2 : 0; 

   return  $symbol.$sign .($j ? substr($i,0, $j) + $t : '').preg_replace('/(\d{3})(?=\d)/',"$1" + $t,substr($i,$j)) ;

}
  
 
  public static function find_by_id($id=0) {
    $result_array = self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE id={$id} LIMIT 1");
		return !empty($result_array) ? array_shift($result_array) : false;
  }
  
  public static function find_by_sql($sql="") {
    global $database;
    $result_set = $database->query($sql);
    $object_array = array();
    while ($row = $database->fetch_array($result_set)) {
      $object_array[] = self::instantiate($row);
    }
    return $object_array;
  }


	private static function instantiate($record) {
		// Could check that $record exists and is an array
    $object = new self;
		// Simple, long-form approach:
		// $object->id 				= $record['id'];
		// $object->username 	= $record['username'];
		// $object->password 	= $record['password'];
		// $object->first_name = $record['first_name'];
		// $object->last_name 	= $record['last_name'];
		
		// More dynamic, short-form approach:
		foreach($record as $attribute=>$value){
		  
		    $object->$attribute = $value;
		  
		}
		return $object;
	}
	
	

	protected function attributes() { 
		// return an array of attribute names and their values
	  $attributes = array();
	  foreach(self::$db_fields as $field) {
	    
	      $attributes[$field] = $this->$field;
	    
	  }
	  return $attributes;
	}
	
	protected function sanitized_attributes() {
	  global $database;
	  $clean_attributes = array();
	  // sanitize the values before submitting
	  // Note: does not alter the actual value of each attribute
	  foreach($this->attributes() as $key => $value){
	    $clean_attributes[$key] = $database->escape_value($value);
	  }
	  return $clean_attributes;
	}
	
	public function save() {
	  // A new record won't have an id yet.
	  return isset($this->id) ? $this->update() : $this->create();
	}
	
	public function create() {
		global $database;
	
		$attributes = $this->sanitized_attributes();
	  $sql = "INSERT INTO ".self::$table_name." (";
		$sql .= join(", ", array_keys($attributes));
	  $sql .= ") VALUES ('";
		$sql .= join("', '", array_values($attributes));
		$sql .= "')";
	  if($database->query($sql)) {
	    $this->id = $database->insert_id();
	    return true;
	  } else {
	    return false;
	  }
	}

	public function update() {
	  global $database;
		$attributes = $this->sanitized_attributes();
		$attribute_pairs = array();
		foreach($attributes as $key => $value) {
		  $attribute_pairs[] = "{$key}='{$value}'";
		}
		$sql = "UPDATE ".self::$table_name." SET ";
		$sql .= join(", ", $attribute_pairs);
		$sql .= " WHERE id=". $database->escape_value($this->id);
	  $database->query($sql);
	  return ($database->affected_rows() == 1) ? true : false;
	}

	public function delete() {
		global $database;
		// Don't forget your SQL syntax and good habits:
		// - DELETE FROM table WHERE condition LIMIT 1
		// - escape all values to prevent SQL injection
		// - use LIMIT 1
	  $sql = "DELETE FROM ".self::$table_name;
	  $sql .= " WHERE id=". $database->escape_value($this->id);
	  $sql .= " LIMIT 1";
	  $database->query($sql);
	  return ($database->affected_rows() == 1) ? true : false;
	}

}

?>