<?php
// If it's going to need the database, then it's 
// probably smart to require it before we start.
require_once('database.php');
class schoolInformation {
	
	protected static $table_name="school_infor";
	protected static $db_fields = array('school_name', 'school_address');
	public $id;
	public $school_name;
	public $school_address;
	
	// Common Database Methods
	public static function find_all() {
		return self::find_by_sql("SELECT * FROM ".self::$table_name);
  }
  
  public static function find_school_name() {
  	global $database;
    $infor=$database->query("SELECT `school_name` FROM ".self::$table_name." ORDER BY `id` DESC LIMIT 1");
		$infor=$database->fetch_array($infor);
		echo  $infor=strtoupper($infor['school_name']);
		
  }
  
   public static function find_school_address() {
   	 global $database;
    $infor=$database->query("SELECT `school_address` FROM ".self::$table_name." ORDER BY `id` DESC LIMIT 1");
		$infor=$database->fetch_array($infor);
		return $infor=$infor['school_address'];
		
  }


 public static function find_school_abbreviation() {
   	 global $database;
    $infor=$database->query("SELECT `abbreviation` FROM ".self::$table_name." ORDER BY `id` DESC LIMIT 1");
		$infor=$database->fetch_array($infor);
		return $infor=$infor['abbreviation'];
		
  }

  public static function find_school_url() {
   	 global $database;
    $infor=$database->query("SELECT `url` FROM ".self::$table_name." ORDER BY `id` DESC LIMIT 1");
		$infor=$database->fetch_array($infor);
		return $infor=$infor['url'];
		
  }




  public static function find_by_sql($sql="") {
    global $database;
    $result_set = $database->query($sql);
    $object_array = array();
    while ($row = $database->fetch_array($result_set)) {
      $object_array[] = self::instantiate($row);
    }
    return $object_array;
  }


	private static function instantiate($record) {
		// Could check that $record exists and is an array
    $object = new self;
		// Simple, long-form approach:
		// $object->id 				= $record['id'];
		// $object->username 	= $record['username'];
		// $object->password 	= $record['password'];
		// $object->first_name = $record['first_name'];
		// $object->last_name 	= $record['last_name'];
		
		// More dynamic, short-form approach:
		foreach($record as $attribute=>$value){
		  
		    $object->$attribute = $value;
		  
		}
		return $object;
	}
	
	

	protected function attributes() { 
		// return an array of attribute names and their values
	  $attributes = array();
	  foreach(self::$db_fields as $field) {
	    
	      $attributes[$field] = $this->$field;
	    
	  }
	  return $attributes;
	}
	
	protected function sanitized_attributes() {
	  global $database;
	  $clean_attributes = array();
	  // sanitize the values before submitting
	  // Note: does not alter the actual value of each attribute
	  foreach($this->attributes() as $key => $value){
	    $clean_attributes[$key] = $database->escape_value($value);
	  }
	  return $clean_attributes;
	}
	
	
	public function save() {
	  // A new record won't have an id yet.
	  return isset($this->id) ? $this->update() : $this->create();
	}
	
	public function create() {
		global $database;
	
		$attributes = $this->sanitized_attributes();
	  $sql = "INSERT INTO ".self::$table_name." (";
		$sql .= join(", ", array_keys($attributes));
	  $sql .= ") VALUES ('";
		$sql .= join("', '", array_values($attributes));
		$sql .= "')";
	  if($database->query($sql)) {
	    $this->id = $database->insert_id();
	    return true;
	  } else {
	    return false;
	  }
	}

	public function update() {
	  global $database;
		// Don't forget your SQL syntax and good habits:
		// - UPDATE table SET key='value', key='value' WHERE condition
		// - single-quotes around all values
		// - escape all values to prevent SQL injection
		$attributes = $this->sanitized_attributes();
		$attribute_pairs = array();
		foreach($attributes as $key => $value) {
		  $attribute_pairs[] = "{$key}='{$value}'";
		}
		$sql = "UPDATE ".self::$table_name." SET ";
		$sql .= join(", ", $attribute_pairs);
		$sql .= " WHERE id=". $database->escape_value($this->id);
	  $database->query($sql);
	  return ($database->affected_rows() == 1) ? true : false;
	}

	public function delete() {
		global $database;
		// Don't forget your SQL syntax and good habits:
		// - DELETE FROM table WHERE condition LIMIT 1
		// - escape all values to prevent SQL injection
		// - use LIMIT 1
	  $sql = "DELETE FROM ".self::$table_name;
	  $sql .= " WHERE id=". $database->escape_value($this->id);
	  $sql .= " LIMIT 1";
	  $database->query($sql);
	  return ($database->affected_rows() == 1) ? true : false;
	}

}

?>