( function ( $ ) {
	const wcf_update_checkout_on_return = function () {
		const vis = ( function () {
			let stateKey, eventKey;
			const keys = {
				hidden: 'visibilitychange',
				webkitHidden: 'webkitvisibilitychange',
				mozHidden: 'mozvisibilitychange',
				msHidden: 'msvisibilitychange',
			};
			for ( stateKey in keys ) {
				if ( stateKey in document ) {
					eventKey = keys[ stateKey ];
					break;
				}
			}

			return function ( c ) {
				if ( c ) {
					document.addEventListener( eventKey, c );
				}
				return ! document[ stateKey ];
			};
		} )();

		function getCookie( name ) {
			const cookieArr = document.cookie.split( ';' );
			for ( let i = 0; i < cookieArr.length; i++ ) {
				const cookiePair = cookieArr[ i ].split( '=' );

				if ( name === cookiePair[ 0 ].trim() ) {
					return decodeURIComponent( cookiePair[ 1 ] );
				}
			}
			return null;
		}

		vis( function () {
			const active_checkout_cookie = getCookie(
				cartflows.active_checkout_cookie
			);

			if ( active_checkout_cookie && vis() ) {
				if (
					parseInt( cartflows.current_step ) !==
					parseInt( active_checkout_cookie )
				) {
					// Add loader.
					$(
						'.woocommerce-checkout-payment, .woocommerce-checkout-review-order-table'
					).block( {
						message: null,
						overlayCSS: {
							background: '#fff',
							opacity: 0.6,
						},
					} );

					console.log( 'Multiple checkouts are open.' );

					$( document.body ).trigger( 'update_checkout' );

					$( document ).ajaxComplete( function ( event, xhr ) {
						if ( ! xhr.hasOwnProperty( 'responseJSON' ) ) {
							return;
						}
						const fragmants = xhr.responseJSON.hasOwnProperty(
							'fragments'
						)
							? xhr.responseJSON.fragments
							: null;

						if (
							fragmants &&
							fragmants.hasOwnProperty( 'wcf_cart_data' )
						) {
							$(
								document.body
							).trigger( 'wcf_cart_data_restored', [
								fragmants.wcf_cart_data,
							] );
						}
					} );
				}
			}
		} );
	};

	/**
	 * Checkout Custom Field Validations
	 * This will collect all the present fields in the woocommerce form and adds an class if the field
	 * is blank
	 */
	const wcf_custom_field_validation = function () {
		const custom_field_add_class = function (
			field_value,
			field_row,
			field_wrap,
			field_type
		) {
			if (
				field_value === '' ||
				( 'select' === field_type && field_value === ' ' )
			) {
				if ( field_row.hasClass( 'validate-required' ) ) {
					field_wrap.addClass( 'field-required' );
				}
			} else {
				field_wrap.removeClass( 'field-required' );
			}
		};

		const fields_wrapper = $( 'form.woocommerce-checkout' ),
			$all_fields = fields_wrapper.find( 'input, textarea' ),
			$selects = fields_wrapper.find( 'select' );

		$all_fields.on( 'blur', function () {
			const $this = $( this ),
				field_type = $this.attr( 'type' ),
				field_row = $this.closest( 'p.form-row' ),
				field_value = $this.val();

			custom_field_add_class( field_value, field_row, $this, field_type );
		} );

		$selects.on( 'blur', function () {
			const $this = $( this ),
				field_row = $this.closest( 'p.form-row' ),
				field_type = 'select',
				field_wrap = field_row.find( '.select2-container--default' ),
				field_value = field_row.find( 'select' ).val();

			custom_field_add_class(
				field_value,
				field_row,
				field_wrap,
				field_type
			);
		} );
	};

	const wcf_check_is_local_storage = function () {
		const test = 'test';
		try {
			localStorage.setItem( test, test );
			localStorage.removeItem( test );
			return true;
		} catch ( e ) {
			return false;
		}
	};

	const wcf_persistent_data = function () {
		if ( 'yes' !== cartflows.allow_persistence ) {
			return;
		}

		if ( false === wcf_check_is_local_storage() ) {
			return;
		}

		const checkout_cust_form =
			'form.woocommerce-checkout #customer_details';

		const wcf_form_data = {
			set() {
				const checkout_data = [];
				const checkout_form = $(
					'form.woocommerce-checkout #customer_details'
				);

				localStorage.removeItem( 'cartflows_checkout_form' );

				checkout_form
					.find(
						'input[type=text], select, input[type=email], input[type=tel]'
					)
					.each( function () {
						checkout_data.push( {
							name: this.name,
							value: this.value,
						} );
					} );

				cartflows_checkout_form = JSON.stringify( checkout_data );
				localStorage.setItem(
					'cartflows_checkout_form',
					cartflows_checkout_form
				);
			},
			get() {
				if (
					localStorage.getItem( 'cartflows_checkout_form' ) !== null
				) {
					checkout_data = JSON.parse(
						localStorage.getItem( 'cartflows_checkout_form' )
					);

					for ( let i = 0; i < checkout_data.length; i++ ) {
						if (
							$(
								'form.woocommerce-checkout [name=' +
									checkout_data[ i ].name +
									']'
							).hasClass( 'select2-hidden-accessible' )
						) {
							$(
								'form.woocommerce-checkout [name=' +
									checkout_data[ i ].name +
									']'
							).selectWoo( 'val', [ checkout_data[ i ].value ] );
						} else {
							$(
								'form.woocommerce-checkout [name=' +
									checkout_data[ i ].name +
									']'
							).val( checkout_data[ i ].value );
						}
					}
				}
			},
		};

		wcf_form_data.get();

		$(
			checkout_cust_form + ' input, ' + checkout_cust_form + ' select'
		).on( 'change', function () {
			wcf_form_data.set();
		} );
	};

	const wcf_checkout_coupons = {
		init() {
			$( document.body ).on(
				'click',
				'.wcf-submit-coupon',
				this.submit_coupon
			);
			$( document.body ).on(
				'click',
				'.wcf-remove-coupon',
				this.remove_coupon
			);
		},

		submit_coupon( e ) {
			e.preventDefault();
			const coupon_wrapper_class = $( '.wcf-custom-coupon-field' ),
				coupon_wrapper = $( this ).closest( coupon_wrapper_class ),
				coupon_field = coupon_wrapper.find( '.wcf-coupon-code-input' ),
				coupon_value = coupon_field.val();

			if ( '' === coupon_value ) {
				coupon_field.addClass( 'field-required' );
				return false;
			}
			coupon_field.removeClass( 'field-required' );

			const data = {
				coupon_code: coupon_value,
				action: 'wcf_woo_apply_coupon',
				security: cartflows.wcf_validate_coupon_nonce,
			};

			$.ajax( {
				type: 'POST',
				url: cartflows.ajax_url,
				data,

				success( code ) {
					const coupon_message = $( '.wcf-custom-coupon-field' );
					coupon_message
						.find( '.woocommerce-error, .woocommerce-message' )
						.remove();

					const code_data = JSON.parse( code );

					if ( code_data.status === true ) {
						$( document.body ).trigger( 'update_checkout', {
							update_shipping_method: false,
						} );
						coupon_message.prepend( code_data.msg );
						coupon_wrapper_class.addClass( 'wcf-coupon-applied' );
					} else {
						coupon_message.prepend( code_data.msg );
						coupon_wrapper_class.removeClass(
							'wcf-coupon-applied'
						);
					}
				},
			} );
		},

		remove_coupon( e ) {
			e.preventDefault();
			const data = {
				coupon_code: $( this ).attr( 'data-coupon' ),
				action: 'wcf_woo_remove_coupon',
				security: cartflows.wcf_validate_remove_coupon_nonce,
			};

			$.ajax( {
				type: 'POST',
				url: cartflows.ajax_url,
				data,

				success( code ) {
					const coupon_message = $( '.wcf-custom-coupon-field' );
					coupon_message
						.find( '.woocommerce-error, .woocommerce-message' )
						.hide();

					$( '.wcf-custom-coupon-field' ).removeClass(
						'wcf-coupon-applied'
					);

					if ( code ) {
						$( document.body ).trigger( 'update_checkout', {
							update_shipping_method: false,
						} );
						coupon_message.prepend( code );
					}
				},
			} );
		},
	};

	const wcf_remove_cart_products = function () {
		$( document.body ).on(
			'click',
			'#wcf-embed-checkout-form .wcf-remove-product',
			function ( e ) {
				e.preventDefault();
				const p_id = $( this ).attr( 'data-id' );
				const data = {
					p_key: $( this ).attr( 'data-item-key' ),
					p_id,
					action: 'wcf_woo_remove_cart_product',
					security: cartflows.wcf_validate_remove_cart_product_nonce,
				};

				$.ajax( {
					type: 'POST',
					url: cartflows.ajax_url,
					data,

					success( response ) {
						const res_data = JSON.parse( response );

						if ( res_data.need_shipping === false ) {
							// $('#wcf-embed-checkout-form').find('#ship-to-different-address-checkbox').hide();
							$( '#wcf-embed-checkout-form' )
								.find( '#ship-to-different-address-checkbox' )
								.attr( 'checked', false );
						}
						$( '#wcf-embed-checkout-form' )
							.find( '.woocommerce-notices-wrapper' )
							.first()
							.html( res_data.msg );
						$( document ).trigger( 'cartflows_remove_product', [
							p_id,
						] );
						$( '#wcf-embed-checkout-form' ).trigger(
							'update_checkout'
						);
					},
				} );
			}
		);
	};

	const wcf_anim_field_label_event = function () {
		//Add focus class automatically if value is present in input
		const $all_inputs = $(
			'.wcf-field-style-one form.woocommerce-checkout'
		).find( 'input' );

		$( $all_inputs ).each( function () {
			const $this = $( this ),
				field_type = $this.attr( 'type' ),
				form_row = $this.closest( '.form-row' ),
				has_class = form_row.hasClass( 'mt20' );
			let input_elem_value = $this.val();

			$this.attr( 'placeholder', '' );

			const input_placeholder = $this.attr( 'placeholder' )
				? $this.attr( 'placeholder' )
				: '';

			if ( '' === input_elem_value && '' !== input_placeholder ) {
				input_elem_value = input_placeholder;
			}

			_add_anim_class(
				has_class,
				input_elem_value,
				field_type,
				form_row
			);
		} );

		//Add focus class automatically if value is present in selects
		const $all_selects = $(
			'.wcf-field-style-one form.woocommerce-checkout'
		).find( 'select' );

		$( $all_selects ).each( function () {
			const $this = $( this ),
				form_row = $this.closest( '.form-row' ),
				field_type = 'select',
				has_class = form_row.hasClass( 'mt20' ),
				input_elem_value = $this.val();

			_add_anim_class(
				has_class,
				input_elem_value,
				field_type,
				form_row
			);
		} );

		// Common function to add wcf-anim-label
		function _add_anim_class(
			has_class,
			input_elem_value,
			field_type,
			form_row
		) {
			if ( has_class ) {
				form_row.removeClass( 'mt20' );
			}

			if (
				input_elem_value !== '' ||
				( input_elem_value !== ' ' && 'select' === field_type )
			) {
				form_row.addClass( 'wcf-anim-label' );
			}

			if ( field_type === 'hidden' ) {
				form_row.removeClass( 'wcf-anim-label' );
				form_row.addClass( 'wcf-anim-label-fix' );
			}
		}
	};

	/**
	 * Label Animation
	 */
	const wcf_anim_field_label = function () {
		const $inputs = $(
			'.wcf-field-style-one form.woocommerce-checkout, .wcf-field-style-one form.woocommerce-form-login'
		).find( 'input' );
		const $select_input = $(
			'.wcf-field-style-one form.woocommerce-checkout'
		).find( '.select2' );
		const $textarea = $(
			'.wcf-field-style-one form.woocommerce-checkout'
		).find( 'textarea' );

		//Add focus class on clicked on input types
		$inputs.on( 'focus', function () {
			const $this = $( this ),
				field_row = $this.closest( '.form-row' );
			has_class = field_row.hasClass( 'wcf-anim-label' );
			field_value = $this.val();

			if ( field_value === '' ) {
				field_row.addClass( 'wcf-anim-label' );
			}
		} );

		//Remove focus class on clicked outside/other input types
		$inputs.on( 'focusout', function () {
			const $this = $( this ),
				field_row = $this.closest( '.form-row' ),
				field_value = $this.val(),
				field_placeholder = $this.attr( 'placeholder' )
					? $this.attr( 'placeholder' )
					: '';

			if ( '' === field_value && '' === field_placeholder ) {
				field_row.removeClass( 'wcf-anim-label' );
			} else {
				field_row.addClass( 'wcf-anim-label' );
			}
		} );

		//Add focus class on clicked on Select
		$select_input.on( 'click', function () {
			const $this = $( this ),
				field_row = $this.closest( '.form-row' );
			has_class = field_row.hasClass( 'wcf-anim-label' );
			field_value = $this.find( '.select2-selection__rendered' ).text();

			if ( field_value === '' ) {
				field_row.addClass( 'wcf-anim-label' );
			}
		} );

		//Remove focus class on clicked outside/another Select or fields
		$select_input.on( 'focusout', function () {
			const $this = $( this ),
				field_row = $this.closest( '.form-row' );
			has_class = field_row.hasClass( 'wcf-anim-label' );
			field_value = $this.find( '.select2-selection__rendered' ).text();

			if ( field_value === '' ) {
				field_row.removeClass( 'wcf-anim-label' );
			} else {
				field_row.addClass( 'wcf-anim-label' );
			}
		} );

		//Add focus class on clicked on textarea
		$textarea.on( 'click', function () {
			const $this = $( this ),
				field_row = $this.closest( '.form-row' );
			has_class = field_row.hasClass( 'wcf-anim-label' );
			field_value = $this.val();

			if ( field_value === '' ) {
				field_row.addClass( 'wcf-anim-label' );
			}
		} );

		//Remove focus class on clicked outside/another textarea or fields
		$textarea.on( 'focusout', function () {
			const $this = $( this ),
				field_row = $this.closest( '.form-row' );
			has_class = field_row.hasClass( 'wcf-anim-label' );
			field_value = $this.val();

			if ( field_value === '' ) {
				field_row.removeClass( 'wcf-anim-label' );
			} else {
				field_row.addClass( 'wcf-anim-label' );
			}
		} );
	};

	const wcf_toggle_optimized_fields = function () {
		jQuery.each(
			cartflows_checkout_optimized_fields,
			function ( field, cartflows_optimized_field ) {
				if ( cartflows_optimized_field.is_optimized ) {
					jQuery( '#' + field ).prepend(
						'<a href="#" id="wcf_optimized_' +
							field +
							'">' +
							cartflows_optimized_field.field_label +
							'</a>'
					);
					jQuery( '#wcf_optimized_' + field ).on(
						'click',
						function ( e ) {
							e.preventDefault();
							jQuery( '#' + field ).removeClass(
								'wcf-hide-field'
							);
							// jQuery("#" + field).removeClass('mt20')
							const field_id = field.replace( /_field/g, '' );
							$( '#' + field_id ).trigger( 'focus' );
							jQuery( this ).remove();
						}
					);
				}
			}
		);
	};

	const wcf_anim_field_style_two = function () {
		const $inputs = $(
			'.wcf-field-modern-label .woocommerce input, .wcf-field-modern-label .woocommerce select, .wcf-field-modern-label .woocommerce textarea'
		);

		const _add_anim_class = function ( $this ) {
			const field_row = $this.closest( '.form-row' ),
				is_select =
					$this.is( 'select' ) ||
					$this.hasClass( 'select2-hidden-accessible' ),
				field_value = is_select
					? $this.find( ':selected' ).text()
					: $this.val();

			if ( '' === field_value ) {
				field_row.removeClass( 'wcf-anim-label' );
			} else {
				field_row.addClass( 'wcf-anim-label' );
			}
		};

		/**
		 * Function to add the * to the required fields if marked.
		 *
		 * @param {Object} $this the current focused field.
		 */
		const _show_required_field_mark = function ( $this ) {
			const field_row = $this.closest( '.form-row' ),
				is_required = field_row.hasClass( 'validate-required' );
			let placeholder_text = $this.attr( 'placeholder' );

			if ( is_required && '' !== placeholder_text ) {
				placeholder_text = placeholder_text + ' *';
			}

			$this.attr( 'placeholder', placeholder_text );
		};

		$inputs.on( 'focusout input', function () {
			const $this = $( this );
			_add_anim_class( $this );
		} );

		$( $inputs ).each( function () {
			const $this = $( this );
			_add_anim_class( $this );
			_show_required_field_mark( $this );
		} );
	};

	const validateEmail = function ( email ) {
		const email_reg = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
		return email_reg.test( email );
	};

	let xhrCountEmail = 0;
	let delayTimerEmail;

	const inline_email_address_validation = function () {
		const email = $( '.wcf-customer-info #billing_email' ).val();

		if ( 'undefined' === typeof email || cartflows.is_logged_in ) {
			return;
		}

		if ( '' !== email ) {
			const email_field = $( '#billing_email' );
			const validation_msg_wrap = $( '.wcf-email-validation-block' ),
				customer_login_wrap = $( '.wcf-customer-login-section' );

			validation_msg_wrap.remove();

			if ( ! validateEmail( email ) ) {
				email_field.after(
					'<span class="wcf-email-validation-block error">' +
						cartflows.email_validation_msgs.error_msg +
						'</span>'
				);
				customer_login_wrap.removeClass( 'wcf-show' );
				return false;
			}

			clearTimeout( delayTimerEmail );

			const seqNumber = ++xhrCountEmail;

			delayTimerEmail = setTimeout( function () {
				$.ajax( {
					url: cartflows.ajax_url,
					type: 'POST',
					data: {
						action: 'wcf_check_email_exists',
						email_address: email,
						security: cartflows.check_email_exist_nonce,
					},
					success( resp ) {
						if ( seqNumber !== xhrCountEmail ) {
							return;
						}

						validation_msg_wrap.remove();

						if (
							resp.data.success &&
							customer_login_wrap.hasClass( 'wcf-show' )
						) {
							email_field.after(
								'<span class="wcf-email-validation-block success">' +
									cartflows.email_validation_msgs
										.success_msg +
									'</span>'
							);
							return;
						}

						if ( resp.data.success ) {
							if ( resp.data.is_login_allowed ) {
								email_field.after(
									'<span class="wcf-email-validation-block success">' +
										cartflows.email_validation_msgs
											.success_msg +
										'</span>'
								);

								customer_login_wrap
									.slideDown( 400 )
									.addClass( 'wcf-show' );
							}

							$( '.wcf-create-account-section' ).hide();
							$(
								'.woocommerce-billing-fields__customer-login-label'
							).show();
						} else {
							customer_login_wrap
								.slideUp( 400 )
								.removeClass( 'wcf-show' );

							//Learndash Woo integration plugin hides the create aacount checkbox.So need to show it again.
							$(
								'.wcf-create-account-section .create-account label.checkbox'
							).show();

							$( '.wcf-create-account-section' ).show();

							$(
								'.woocommerce-billing-fields__customer-login-label'
							).hide();
						}
					},
				} );
			}, 300 );
		} else {
			$( '.wcf-create-account-section' ).hide();
			$( '.wcf-customer-login-section' ).hide();
			$( '.wcf-email-validation-block' ).hide();
			$( '.woocommerce-billing-fields__customer-login-label' ).show();
		}

		return false;
	};

	const woocommerce_user_login = function () {
		$( '.wcf-customer-login-url' ).on( 'click', function login_form() {
			const customer_login_wrap = $( '.wcf-customer-login-section' );

			if ( customer_login_wrap.hasClass( 'wcf-show' ) ) {
				customer_login_wrap.slideUp( 400 );
				customer_login_wrap.removeClass( 'wcf-show' );
			} else {
				customer_login_wrap.slideDown( 400 );
				customer_login_wrap.addClass( 'wcf-show' );
			}
		} );

		$( '.wcf-customer-login-section__login-button' ).on(
			'click',
			function name() {
				const email = $( '#billing_email' ).val();
				const password = $( '#billing_password' ).val();

				$.ajax( {
					url: cartflows.ajax_url,
					type: 'POST',
					data: {
						action: 'wcf_woocommerce_login',
						email,
						password,
						security: cartflows.woocommerce_login_nonce,
					},
					success( resp ) {
						if ( resp.data.success ) {
							location.reload();
						} else {
							$( '.wcf-customer-info__notice' )
								.addClass( 'wcf-notice' )
								.html( resp.data.error );
						}
					},
				} );
			}
		);
	};

	const wcf_order_review_toggler = function () {
		const mobile_order_review_wrap = $(
				'.wcf_cartflows_review_order_wrapper'
			),
			desktop_order_review_wrap = $( '.wcf-order-wrap' );

		let timeout = false;
		const resizeEvent =
			'onorientationchange' in window ? 'orientationchange' : 'resize';

		$( '.wcf-order-review-toggle' ).on(
			'click',
			function wcf_show_order_summary( e ) {
				e.preventDefault();

				if ( mobile_order_review_wrap.hasClass( 'wcf-show' ) ) {
					mobile_order_review_wrap.slideUp( 400 );
					mobile_order_review_wrap.removeClass( 'wcf-show' );
					$( this ).removeClass( 'wcf-show' );
					$( '.wcf-order-review-toggle-text' ).text(
						cartflows.order_review_toggle_texts.toggle_show_text
					);
				} else {
					mobile_order_review_wrap.slideDown( 400 );
					mobile_order_review_wrap.addClass( 'wcf-show' );
					$( this ).addClass( 'wcf-show' );
					$( '.wcf-order-review-toggle-text' ).text(
						cartflows.order_review_toggle_texts.toggle_hide_text
					);
				}
			}
		);

		$( window ).on( resizeEvent, function () {
			clearTimeout( timeout );

			timeout = setTimeout( function () {
				const width = window.innerWidth || $( window ).width();

				if ( width >= 769 ) {
					mobile_order_review_wrap.css( { display: 'none' } );
					mobile_order_review_wrap.removeClass( 'wcf-show' );
					$( '.wcf-order-review-toggle' ).removeClass( 'wcf-show' );
					$( '.wcf-order-review-toggle-text' ).text(
						cartflows.order_review_toggle_texts.toggle_show_text
					);
				}
			}, 200 );
		} );

		// Update checkout when shipping methods changes.
		mobile_order_review_wrap.on(
			'change',
			'select.shipping_method, input[name^="shipping_method"]',
			function () {
				/**
				 * Uncheck all shipping radio buttons of desktop. Those will be auto updated by update_checkout action.
				 * While performing the update checkout, it searches for the selected shipping method in whole page.
				 */
				desktop_order_review_wrap
					.find(
						'input[name^="shipping_method"][type="radio"]:checked'
					)
					.each( function () {
						$( this ).removeAttr( 'checked' );
					} );

				$( document.body ).trigger( 'update_checkout', {
					update_shipping_method: true,
				} );
			}
		);
	};

	$( function () {
		wcf_persistent_data();

		wcf_update_checkout_on_return();

		wcf_custom_field_validation();

		wcf_remove_cart_products();

		wcf_checkout_coupons.init();

		wcf_anim_field_label_event();

		wcf_anim_field_label();

		wcf_toggle_optimized_fields();

		wcf_anim_field_style_two();

		// On email input field change.
		$( '.wcf-customer-info #billing_email' ).on( 'input', function () {
			inline_email_address_validation();
		} );

		// On page load as we saves the checkout fields values.
		if ( $( '.wcf-customer-info #billing_email' ).length > 0 ) {
			inline_email_address_validation();
		}

		woocommerce_user_login();

		wcf_order_review_toggler();
	} );
} )( jQuery );
